/*
* FirmwareUpdateManager.h
*
*  Created on: 30.11.2009
*      Author: stefan.detter
*/

#ifndef FIRMWAREUPDATEMANAGER_H_
#define FIRMWAREUPDATEMANAGER_H_

#include <QObject>

#include <QMap>
#include <QSet>
#include <QFileInfo>
#include <QUrl>

#include <QrfeTraceModule>

#include <QrfeReaderManager>

#include <def.h>

#include "../Resource.h"

typedef struct{
	QFileInfo	file;
	QDateTime	creation;
} ImageInfo;

class FirmwareUpdateManager : public QObject, QrfeTraceModule
{
	Q_OBJECT

public:
	FirmwareUpdateManager(QWidget* window, QObject* parent = 0);
	virtual ~FirmwareUpdateManager();

	void init();

signals:
	void appendGlobalJob(JobType type, const QList<QVariant>& params);

public slots:
	void addFileRequest ( const QFileInfo& file, bool& yesToAll, bool& result, QString& errMsg );

public:
	void checkReaderForUpdates(QrfeReaderInterface* reader);

	QMap<ulong, QMap<ulong, ImageInfo> >  	getAvailableSoftwareRevisions (ulong readerType, ulong hardwareRevision);
	QMap<ulong, QMap<ulong, ImageInfo> >  	getAvailableSoftwareRevisions (QSet<ulong> readerType, ulong hardwareRevision);
	QMap<ulong, QMap<ulong, ImageInfo> >  	getAvailableTestSoftwareRevisions (ulong readerType, ulong hardwareRevision);
	QMap<ulong, QMap<ulong, ImageInfo> >  	getAvailableTestSoftwareRevisions (QSet<ulong> readerType, ulong hardwareRevision);
    QMap<ulong, QMap<ulong, ImageInfo> >  	getAvailableBootloaderRevisions (ulong readerType, ulong hardwareRevision, bool allowCharSwitch);

	QFileInfo		    					getImageFile(ulong readerType, ulong hardwareRevision, ulong softwareRevision, bool isBootloader);

private:
	bool isTestFirmware(ulong &softwareRevision);

	bool checkFile (const QFileInfo& file, ulong &readerType, ulong &hardwareRevision, ulong &softwareRevision, bool &isBootloader, QString &error);
	bool parseFile (const QFileInfo& file, ulong readerType, ulong hardwareRevision, ulong softwareRevision, QString &error);

	bool insertFile(const QFileInfo& file, QString &error);

	void dumpRepository();
	void dumpTestRepository();
	void dumpBootloaderRepository();

	ulong byteArrayToUlong(QByteArray ba);

	QMap<ulong, QMap<ulong, QMap<ulong, ImageInfo> > >	m_imageList;
	QMap<ulong, QMap<ulong, QMap<ulong, ImageInfo> > >	m_testImageList;
	QMap<ulong, QMap<ulong, QMap<ulong, ImageInfo> > >	m_bootloaderImageList;
	QWidget* 											m_window;
};

#endif /* FIRMWAREUPDATEMANAGER_H_ */
